package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.DatosLocalizacion;
import com.ejie.ab04b.model.nora.Localidad;
import com.ejie.ab04b.model.nora.Municipio;
import com.ejie.ab04b.model.nora.Provincia;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0467s00DaoImpl generated by UDA, 21-Feb-2017 12:47:21.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DatosLocalizacionDaoImpl implements DatosLocalizacionDao {

	private static final String QUERY_SELECT = "SELECT t1.COD_LOCALIZACION_067 CODLOCALIZACION067, t1.COD_PROVINCIA_067 CODPROVINCIA067, t1.COD_COMARCA_067 CODCOMARCA067, t1.COD_MUNICIPIO_067 CODMUNICIPIO067, t1.COD_LOCALIDAD_067 CODLOCALIDAD067, t1.CALLE_067 CALLE067, t1.PORTAL_067 PORTAL067, t1.CODPOSTAL_067 CODPOSTAL067, t1.PISO_067 PISO067, t1.PUERTA_067 PUERTA067 FROM AB0467S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosLocalizacion> rwMap = new RowMapper<DatosLocalizacion>() {
		public DatosLocalizacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosLocalizacion(resultSet.getInt("CODLOCALIZACION067"),
					new Provincia(resultSet.getString("CODPROVINCIA067")),
					resultSet.getString("CODCOMARCA067"),
					new Municipio(resultSet.getString("CODMUNICIPIO067")),
					new Localidad(resultSet.getString("CODLOCALIDAD067")),
					resultSet.getString("CALLE067"),
					resultSet.getString("PORTAL067"),
					resultSet.getString("CODPOSTAL067"),
					resultSet.getString("PISO067"),
					resultSet.getString("PUERTA067"));
		}
	};

	private RowMapper<DatosLocalizacion> rwMapPK = new RowMapper<DatosLocalizacion>() {
		public DatosLocalizacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosLocalizacion(
					resultSet.getInt("CODLOCALIZACION067"));
		}
	};

	/**
	 * Gets the jdbc template.
	 * 
	 *  JdbcTemplate
	 *
	 * @return the jdbc template
	 */
	public JdbcTemplate getJdbcTemplate() {
		return this.jdbcTemplate;
	}

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the datos localizacion
	 */
	public DatosLocalizacion add(DatosLocalizacion ab0467s00) {
		String query = "INSERT INTO AB0467S00 (COD_LOCALIZACION_067, COD_PROVINCIA_067, COD_COMARCA_067, COD_MUNICIPIO_067, COD_LOCALIDAD_067, CALLE_067, PORTAL_067, CODPOSTAL_067, PISO_067, PUERTA_067) VALUES (?,?,?,?,?,?,?,?,?,?)";

		ab0467s00.setCodLocalizacion067(
				Secuencias.DATOS_LOCALIZACION.getNextInteger(jdbcTemplate));

		this.jdbcTemplate.update(query, ab0467s00.getCodLocalizacion067(),
				(ab0467s00.getProvincia() != null
						? ab0467s00.getProvincia().getCodProvincia() : ""),
				ab0467s00.getCodComarca067(),
				(ab0467s00.getMunicipio() != null
						? ab0467s00.getMunicipio().getCodMunicipio() : ""),
				(ab0467s00.getLocalidad() != null
						? ab0467s00.getLocalidad().getCodLocalidad() : ""),
				ab0467s00.getCalle067(), ab0467s00.getPortal067(),
				ab0467s00.getCodpostal067(), ab0467s00.getPiso067(),
				ab0467s00.getPuerta067());
		return ab0467s00;
	}

	/**
	 * Updates a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the datos localizacion
	 */
	public DatosLocalizacion update(DatosLocalizacion ab0467s00) {
		String query = "UPDATE AB0467S00 SET COD_PROVINCIA_067=?, COD_COMARCA_067=?, COD_MUNICIPIO_067=?, COD_LOCALIDAD_067=?, CALLE_067=?, PORTAL_067=?, CODPOSTAL_067=?, PISO_067=?, PUERTA_067=? WHERE COD_LOCALIZACION_067=?";
		this.jdbcTemplate.update(query,
				(ab0467s00.getProvincia() != null
						? ab0467s00.getProvincia().getCodProvincia() : ""),
				ab0467s00.getCodComarca067(),
				(ab0467s00.getMunicipio() != null
						? ab0467s00.getMunicipio().getCodMunicipio() : ""),
				(ab0467s00.getLocalidad() != null
						? ab0467s00.getLocalidad().getCodLocalidad() : ""),
				ab0467s00.getCalle067(), ab0467s00.getPortal067(),
				ab0467s00.getCodpostal067(), ab0467s00.getPiso067(),
				ab0467s00.getPuerta067(), ab0467s00.getCodLocalizacion067());
		return ab0467s00;
	}

	/**
	 * Finds a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the datos localizacion
	 */
	@Transactional(readOnly = true)
	public DatosLocalizacion find(DatosLocalizacion ab0467s00) {
		StringBuilder query = new StringBuilder(
				DatosLocalizacionDaoImpl.QUERY_SELECT);

		query.append(" WHERE t1.COD_LOCALIZACION_067 = ? ");

		List<DatosLocalizacion> ab0467s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap,
				ab0467s00.getCodLocalizacion067());
		return (DatosLocalizacion) DataAccessUtils.uniqueResult(ab0467s00List);
	}

	/**
	 * Removes a single row in the Ab0467s00 table.
	 * 
	 *  ab0467s00            Ab0467s00
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 */
	public void remove(DatosLocalizacion ab0467s00) {
		String query = "DELETE FROM AB0467S00 WHERE COD_LOCALIZACION_067=?";
		this.jdbcTemplate.update(query, ab0467s00.getCodLocalizacion067());
	}

	/**
	 * Finds a list of rows in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0467s00>
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DatosLocalizacion> findAll(DatosLocalizacion ab0467s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DatosLocalizacionDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0467s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DatosLocalizacion>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0467s00 table using like.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0467s00>
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DatosLocalizacion> findAllLike(DatosLocalizacion ab0467s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosLocalizacionDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0467s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DatosLocalizacion>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0467s00 table.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  Long
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DatosLocalizacion ab0467s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0467S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0467s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0467s00 table using like.
	 * 
	 *  ab0467s00
	 *            Ab0467s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DatosLocalizacion ab0467s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0467S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0467s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0467s00 selected for rup_table.
	 * 
	 *  ab0467s00            Ab0467s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0467s00>>
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DatosLocalizacion>> reorderSelection(
			DatosLocalizacion ab0467s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosLocalizacionDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0467s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DatosLocalizacion.class,
				filterParamList, "COD_LOCALIZACION_067");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<DatosLocalizacion>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0467s00
	 *  searchParams            Ab0467s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0467s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DatosLocalizacion>> search(
			DatosLocalizacion filterParams, DatosLocalizacion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosLocalizacionDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DatosLocalizacion.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"COD_LOCALIZACION_067");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<DatosLocalizacion>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0467s00 entity.
	 * 
	 *  ab0467s00            Ab0467s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DatosLocalizacion ab0467s00) {

		StringBuilder where = new StringBuilder(
				DatosLocalizacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0467s00 != null && ab0467s00.getCodLocalizacion067() != null) {
			where.append(" AND t1.COD_LOCALIZACION_067 = ?");
			params.add(ab0467s00.getCodLocalizacion067());
		}
		if (ab0467s00 != null && ab0467s00.getProvincia() != null
				&& ab0467s00.getProvincia().getCodProvincia() != null) {
			where.append(" AND t1.COD_PROVINCIA_067 = ?");
			params.add(ab0467s00.getProvincia().getCodProvincia());
		}
		if (ab0467s00 != null && ab0467s00.getCodComarca067() != null) {
			where.append(" AND t1.COD_COMARCA_067 = ?");
			params.add(ab0467s00.getCodComarca067());
		}
		if (ab0467s00 != null && ab0467s00.getMunicipio() != null
				&& ab0467s00.getMunicipio().getCodMunicipio() != null) {
			where.append(" AND t1.COD_MUNICIPIO_067 = ?");
			params.add(ab0467s00.getMunicipio().getCodMunicipio());
		}
		if (ab0467s00 != null && ab0467s00.getLocalidad() != null
				&& ab0467s00.getLocalidad().getCodLocalidad() != null) {
			where.append(" AND t1.COD_LOCALIDAD_067 = ?");
			params.add(ab0467s00.getLocalidad().getCodLocalidad());
		}
		if (ab0467s00 != null && ab0467s00.getCalle067() != null) {
			where.append(" AND t1.CALLE_067 = ?");
			params.add(ab0467s00.getCalle067());
		}
		if (ab0467s00 != null && ab0467s00.getPortal067() != null) {
			where.append(" AND t1.PORTAL_067 = ?");
			params.add(ab0467s00.getPortal067());
		}
		if (ab0467s00 != null && ab0467s00.getCodpostal067() != null) {
			where.append(" AND t1.CODPOSTAL_067 = ?");
			params.add(ab0467s00.getCodpostal067());
		}
		if (ab0467s00 != null && ab0467s00.getPiso067() != null) {
			where.append(" AND t1.PISO_067 = ?");
			params.add(ab0467s00.getPiso067());
		}
		if (ab0467s00 != null && ab0467s00.getPuerta067() != null) {
			where.append(" AND t1.PUERTA_067 = ?");
			params.add(ab0467s00.getPuerta067());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0467s00 entity.
	 * 
	 *  ab0467s00            Ab0467s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0467s00 the ab 0467 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DatosLocalizacion ab0467s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DatosLocalizacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0467s00 != null && ab0467s00.getCodLocalizacion067() != null) {
			where.append(" AND t1.COD_LOCALIZACION_067 = ?");
			params.add(ab0467s00.getCodLocalizacion067());
		}
		if (ab0467s00 != null && ab0467s00.getProvincia() != null
				&& ab0467s00.getProvincia().getCodProvincia() != null) {
			where.append(
					" AND UPPER(t1.COD_PROVINCIA_067) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						ab0467s00.getProvincia().getCodProvincia().toUpperCase()
								+ "%");
			} else {
				params.add("%" + ab0467s00.getProvincia().getCodProvincia()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.COD_PROVINCIA_067 IS NOT NULL");
		}
		if (ab0467s00 != null && ab0467s00.getCodComarca067() != null) {
			where.append(" AND UPPER(t1.COD_COMARCA_067) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0467s00.getCodComarca067().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0467s00.getCodComarca067().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_COMARCA_067 IS NOT NULL");
		}
		if (ab0467s00 != null && ab0467s00.getMunicipio() != null
				&& ab0467s00.getMunicipio().getCodMunicipio() != null) {
			where.append(
					" AND UPPER(t1.COD_MUNICIPIO_067) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(
						ab0467s00.getMunicipio().getCodMunicipio().toUpperCase()
								+ "%");
			} else {
				params.add("%" + ab0467s00.getMunicipio().getCodMunicipio()
						.toUpperCase() + "%");
			}
			where.append(" AND t1.COD_MUNICIPIO_067 IS NOT NULL");
		}
		if (ab0467s00 != null && ab0467s00.getLocalidad() != null
				&& ab0467s00.getLocalidad().getCodLocalidad() != null) {
			where.append(" AND t1.COD_LOCALIDAD_067 = ?");
			params.add(ab0467s00.getLocalidad().getCodLocalidad());
		}
		if (ab0467s00 != null && ab0467s00.getCalle067() != null) {
			where.append(" AND t1.CALLE_067 = ?");
			params.add(ab0467s00.getCalle067());
		}
		if (ab0467s00 != null && ab0467s00.getPortal067() != null) {
			where.append(" AND t1.PORTAL_067 = ?");
			params.add(ab0467s00.getPortal067());
		}
		if (ab0467s00 != null && ab0467s00.getCodpostal067() != null) {
			where.append(" AND UPPER(t1.CODPOSTAL_067) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0467s00.getCodpostal067().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0467s00.getCodpostal067().toUpperCase() + "%");
			}
			where.append(" AND t1.CODPOSTAL_067 IS NOT NULL");
		}
		if (ab0467s00 != null && ab0467s00.getPiso067() != null) {
			where.append(" AND UPPER(t1.PISO_067) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0467s00.getPiso067().toUpperCase() + "%");
			} else {
				params.add("%" + ab0467s00.getPiso067().toUpperCase() + "%");
			}
			where.append(" AND t1.PISO_067 IS NOT NULL");
		}
		if (ab0467s00 != null && ab0467s00.getPuerta067() != null) {
			where.append(" AND UPPER(t1.PUERTA_067) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0467s00.getPuerta067().toUpperCase() + "%");
			} else {
				params.add("%" + ab0467s00.getPuerta067().toUpperCase() + "%");
			}
			where.append(" AND t1.PUERTA_067 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
